/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.taskcontroller;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.servlet.pmod.task.PanelModelTaskPortal;
import com.ibm.hwmca.fw.servlet.taskcontroller.TaskControllerListener;
import com.ibm.hwmca.fw.servlet.taskcontroller.TaskControllerServlet;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.servlet.util.HMCSessionListener;
import com.ibm.hwmca.fw.servlet.util.ServletRuntime;
import com.ibm.hwmca.fw.servlet.util.TaskWindowPositionManager;
import com.ibm.hwmca.fw.servlet.util.WindowOptions;
import com.ibm.hwmca.fw.servlet.util.WorkQueue;
import com.ibm.hwmca.fw.util.Trace;
import java.awt.Dimension;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class TaskControllerQueue
extends WorkQueue {
    public static final String TRACE_MASK = "HTSKCTL";
    public static final String TRACE_MASKT = "HTSKCTLT";
    public static final String TRACE_MASKF = "HTSKCTLF";
    public static final String TRACE_MASKD = "HTSKCTLD";
    public static final String THIS_CLASS = "TaskControllerQueue";
    private static int REFRESH_COUNT = 0;
    public static final WindowOptions DEFAULT_WINDOW_OPTIONS = new WindowOptions();
    public static final String WINDOW_OPTIONS_FILE_NAME = "TaskWindow.properties";
    private static final String OPEN = "('";
    private static final String CLOSE = "');";
    private static final String COMMA = "', '";
    public static final String URL_PREFIX = "/content?taskId=";
    public static final String WINDOW_PREFIX = "task";
    public static final String WINDOW_OPTIONS_KEY = "taskController.window_options";
    private Set _tasksWithPendingUpdates;
    private HMCSession _hmcSession;
    private Listener listener;
    protected List _taskControllerListeners;
    private TaskControllerServlet servlet;

    public static synchronized TaskControllerQueue getTaskControllerQueue(HMCSession session) {
        Trace.trace(TRACE_MASKF, "--> TaskControllerQueue.getTaskControllerQueue");
        TaskControllerQueue queue = (TaskControllerQueue)session.getSessionAttribute("taskController.queue");
        if (queue == null) {
            Trace.trace(TRACE_MASKF, "TaskControllerQueue.getTaskControllerQueue:  created new queue");
            queue = new TaskControllerQueue(session);
        }
        Trace.trace(TRACE_MASKF, "<-- TaskControllerQueue.getTaskControllerQueue");
        return queue;
    }

    public static String getUrl(PanelModelTaskPortal task) {
        return ServletRuntime.getRuntime().getHMCContextPath() + URL_PREFIX + task.getTaskId();
    }

    public static String getWindowName(PanelModelTaskPortal task) {
        return task.getWindowName();
    }

    public static PanelModelTaskPortal getTask(String taskId, HMCSession session) {
        return session.getPanelModelTaskPortal(taskId);
    }

    public boolean isValidTask(String taskId, HMCSession session) {
        PanelModelTaskPortal task = TaskControllerQueue.getTask(taskId, session);
        return task != null && !task.isTaskEnded();
    }

    TaskControllerQueue(HMCSession hmcSession) {
        this._hmcSession = hmcSession;
        this.listener = new Listener();
        this._hmcSession.addHMCSessionListener(this.listener);
        this._hmcSession.setSessionAttribute("taskController.queue", this);
        this._tasksWithPendingUpdates = new HashSet();
        this._taskControllerListeners = new ArrayList();
    }

    public synchronized void addTaskControllerListener(TaskControllerListener listener) {
        this._taskControllerListeners.add(listener);
    }

    public synchronized void removeTaskControllerListener(TaskControllerListener listener) {
        this._taskControllerListeners.remove(listener);
    }

    synchronized void connectToServlet(TaskControllerServlet servlet) {
        TaskControllerServlet priorServlet = this.servlet;
        this.servlet = servlet;
        Trace.trace(TRACE_MASKT, "TaskControllerQueue " + this + " now connected to servlet " + (Object)((Object)servlet));
        if (priorServlet == null) {
            this.fireTaskControllerConnectedEvent();
        }
    }

    synchronized void disconnectFromServlet(TaskControllerServlet servlet, Exception e) {
        if (servlet != this.servlet) {
            return;
        }
        this.servlet = null;
        Trace.trace(TRACE_MASKT, "TaskControllerQueue " + this + " disconnecting from servlet " + (Object)((Object)servlet));
        this.fireTaskControllerDisconnectedEvent(e);
    }

    private synchronized void fireTaskControllerConnectedEvent() {
        Trace.trace(TRACE_MASKF, "--> TaskControllerQueue.fireTaskControllerConnectedEvent:  ");
        Iterator iterator = new ArrayList(this._taskControllerListeners).iterator();
        while (iterator.hasNext()) {
            TaskControllerListener listener = (TaskControllerListener)iterator.next();
            listener.taskControllerConnected(this._hmcSession);
        }
        Trace.trace(TRACE_MASKF, "<-- TaskControllerQueue.fireTaskControllerConnectedEvent:  ");
    }

    private synchronized void fireTaskControllerDisconnectedEvent(Exception e) {
        Trace.trace(TRACE_MASKF, "--> TaskControllerQueue.fireTaskControllerDisconnectedEvent:  " + e);
        Iterator iterator = new ArrayList(this._taskControllerListeners).iterator();
        while (iterator.hasNext()) {
            TaskControllerListener listener = (TaskControllerListener)iterator.next();
            listener.taskControllerDisconnected(this._hmcSession, e);
        }
        Trace.trace(TRACE_MASKF, "<-- TaskControllerQueue.fireTaskControllerDisconnectedEvent:  ");
    }

    void resendUpdates() {
        if (this._hmcSession.isDisconnected()) {
            return;
        }
        Iterator i = this._tasksWithPendingUpdates.iterator();
        while (i.hasNext()) {
            String taskId = (String)i.next();
            PanelModelTaskPortal task = TaskControllerQueue.getTask(taskId, this._hmcSession);
            if (task == null) continue;
            this.refresh(task);
        }
    }

    protected Set getTasksWithPendingUpdates() {
        return this._tasksWithPendingUpdates;
    }

    void removeFromHistory(String taskID) {
        this.getTasksWithPendingUpdates().remove(taskID);
    }

    public void invalidate() {
        Trace.trace(TRACE_MASKF, "TaskControllerQueue.invalidate:  ");
        super.invalidate();
    }

    public void sendScript(String script) {
        Trace.trace(TRACE_MASKF, "--> TaskControllerQueue.sendScript:  " + script);
        if (this._hmcSession.isDisconnected()) {
            Trace.trace(TRACE_MASKF, "Ignoring sendScript request since HMC session " + this._hmcSession.getSessionId() + " is disconnected.");
            return;
        }
        this.push("<SCRIPT language='JavaScript'> try {" + script + "} catch (tcqe) {} </SCRIPT>");
        Trace.trace(TRACE_MASKF, "<-- TaskControllerQueue.sendScript:  ");
    }

    public void sendDisconnectedScript(String script) {
        Trace.trace(TRACE_MASKF, "--> TaskControllerQueue.sendDisconnectedScript:  " + script);
        this.push("<SCRIPT language='JavaScript'> try {" + script + "} catch (tcqe) {} </SCRIPT>");
        Trace.trace(TRACE_MASKF, "<-- TaskControllerQueue.sendScript:  ");
    }

    public void sendScript(String script, PanelModelTaskPortal task) {
        Trace.trace(TRACE_MASKF, "--> TaskControllerQueue.sendScript:  " + script);
        if (this._hmcSession.isDisconnected()) {
            Trace.trace(TRACE_MASKF, "Ignoring sendScript request since HMC session " + this._hmcSession.getSessionId() + " is disconnected.");
            return;
        }
        this.push("<SCRIPT language='JavaScript'> try {" + script + "} catch (tcqe) {} </SCRIPT>");
        this.getTasksWithPendingUpdates().add(task.getTaskId());
        Trace.trace(TRACE_MASKF, "<-- TaskControllerQueue.sendScript:  ");
    }

    public void sendRawScript(String script, PanelModelTaskPortal task) {
        Trace.trace(TRACE_MASKF, "--> TaskControllerQueue.sendRawScript:  " + script);
        if (this._hmcSession.isDisconnected()) {
            Trace.trace(TRACE_MASKF, "Ignoring sendScript request since HMC session " + this._hmcSession.getSessionId() + " is disconnected.");
            return;
        }
        this.push(script);
        this.getTasksWithPendingUpdates().add(task.getTaskId());
        Trace.trace(TRACE_MASKF, "<-- TaskControllerQueue.sendRawScript:  ");
    }

    public void callTaskWindowFunction(String functionCall, PanelModelTaskPortal task) {
        Trace.trace(TRACE_MASKF, "--> TaskControllerQueue.sendScriptToTaskWindow");
        this.sendScript("window.open( '', '" + TaskControllerQueue.getWindowName(task) + "')." + functionCall, task);
        Trace.trace(TRACE_MASKF, "<-- TaskControllerQueue.sendScriptToTaskWindow");
    }

    public void openWindow(PanelModelTaskPortal task) {
        this.openWindow(task, DEFAULT_WINDOW_OPTIONS);
    }

    public void openWindow(PanelModelTaskPortal task, WindowOptions options) {
        this.openWindow(TaskControllerQueue.getUrl(task), TaskControllerQueue.getWindowName(task), options, task);
        task.setAttribute(WINDOW_OPTIONS_KEY, options);
    }

    public void openWindow(String url, String name, WindowOptions options, PanelModelTaskPortal task) {
        if (this._hmcSession.isDisconnected()) {
            Trace.trace(TRACE_MASKF, "Ignoring openWindow request since HMC session " + this._hmcSession.getSessionId() + " is disconnected.");
            return;
        }
        task.setWindowOpen(true);
        this.sendScript("openWindow('" + url + COMMA + name + COMMA + options + COMMA + this.getRelativeWidth(options) + COMMA + this.getRelativeHeight(options) + CLOSE, task);
    }

    public void refresh(PanelModelTaskPortal task) {
        this.refresh(TaskControllerQueue.getWindowName(task), TaskControllerQueue.getUrl(task) + "&refresh=" + REFRESH_COUNT++, TaskControllerQueue.getWindowOptionsForTask(task), task, false);
    }

    public void refresh(String name, String url, WindowOptions options, PanelModelTaskPortal task) {
        this.refresh(name, url, options, task, false);
    }

    public void refresh(PanelModelTaskPortal task, boolean focus) {
        this.refresh(TaskControllerQueue.getWindowName(task), TaskControllerQueue.getUrl(task) + "&refresh=" + REFRESH_COUNT++, TaskControllerQueue.getWindowOptionsForTask(task), task, focus);
    }

    public void refresh(String name, String url, WindowOptions options, PanelModelTaskPortal task, boolean focus) {
        if (this._hmcSession.isDisconnected()) {
            Trace.trace(TRACE_MASKF, "Ignoring refresh request since HMC session " + this._hmcSession.getSessionId() + " is disconnected.");
            return;
        }
        task.setWindowOpen(true);
        this.sendScript("refreshWindow('" + name + COMMA + url + COMMA + options + COMMA + this.getRelativeWidth(options) + COMMA + this.getRelativeHeight(options) + COMMA + (focus ? "true" : "false") + CLOSE, task);
    }

    private Integer getRelativeWidth(WindowOptions options) {
        Integer relativeWidth = options.getRelativeWidth();
        if (relativeWidth == null) {
            relativeWidth = new Integer(0);
        }
        return relativeWidth;
    }

    private Integer getRelativeHeight(WindowOptions options) {
        Integer relativeHeight = options.getRelativeHeight();
        if (relativeHeight == null) {
            relativeHeight = new Integer(0);
        }
        return relativeHeight;
    }

    public static WindowOptions getWindowOptionsForTask(PanelModelTaskPortal task) {
        WindowOptions options = (WindowOptions)task.getAttribute(WINDOW_OPTIONS_KEY);
        if (options == null) {
            options = (WindowOptions)DEFAULT_WINDOW_OPTIONS.clone();
            task.setAttribute(WINDOW_OPTIONS_KEY, DEFAULT_WINDOW_OPTIONS);
        }
        Dimension windowSize = task.getWindowSize();
        options.setWidth(windowSize.width);
        options.setHeight(windowSize.height);
        TaskWindowPositionManager.WindowPosition winPos = task.getWindowPosition();
        options.setScreenX(winPos.getX());
        options.setScreenY(winPos.getY());
        return options;
    }

    static {
        Properties options = new Properties();
        String propsFileName = "";
        try {
            propsFileName = BaseFileControl.getFilePath(WINDOW_OPTIONS_FILE_NAME) + WINDOW_OPTIONS_FILE_NAME;
            options.load(new FileInputStream(propsFileName));
            DEFAULT_WINDOW_OPTIONS.putProperties(options);
        }
        catch (IllegalArgumentException e) {
            Trace.trace(TRACE_MASKD, "TaskControllerQueue.TaskControllerQueue:  Some of the options specified in " + propsFileName + " are invalid.");
            Trace.trace(TRACE_MASKD, "TaskControllerQueue.TaskControllerQueue:  " + e.getMessage());
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKD, "TaskControllerQueue.TaskControllerQueue:  The windows options file, " + propsFileName + ", was not found.");
            Trace.trace(TRACE_MASKD, "TaskControllerQueue.TaskControllerQueue:  " + e.getMessage(), e);
            DEFAULT_WINDOW_OPTIONS.setLocation(false);
            DEFAULT_WINDOW_OPTIONS.setMenubar(false);
            DEFAULT_WINDOW_OPTIONS.setScrollbars(true);
            DEFAULT_WINDOW_OPTIONS.setToolbar(false);
            DEFAULT_WINDOW_OPTIONS.setWidth(640);
            DEFAULT_WINDOW_OPTIONS.setHeight(480);
            DEFAULT_WINDOW_OPTIONS.setResizable(true);
        }
    }

    private class Listener
    implements HMCSessionListener {
        private Listener() {
        }

        public void sessionDisconnected(HMCSession session) {
            TaskControllerQueue.this.servlet = null;
            TaskControllerQueue.this._tasksWithPendingUpdates.clear();
        }

        public void sessionConnected(HMCSession session) {
        }

        public void sessionDestroyed(HMCSession session) {
            TaskControllerQueue.this.invalidate();
        }

        public void clientConnectivityLost(HMCSession session) {
        }

        public void clientConnectivityGained(HMCSession session) {
        }

        public void taskStarted(HMCSession session, PanelModelTaskPortal portal) {
        }

        public void taskEnded(HMCSession session, PanelModelTaskPortal portal) {
        }

        public void taskRealized(HMCSession session, PanelModelTaskPortal portal) {
        }
    }
}

